package com.bitbof.escape.entities;

import org.lwjgl.examples.spaceinvaders.Texture;
import org.lwjgl.opengl.GL11;

import com.bitbof.escape.Art;

public class Popup implements Entity{
	
	
	public boolean fadein = true, fadeout = true;
	public int wait = 0, in = 100, show = 1000, out = 100;
	public Texture texture;
	public int counter = 0;
	public World world;
	
	
	public Popup (World world) {
		this.world = world;
	}
	
	@Override
	public void tick() {
		counter++;
		
	}

	@Override
	public void render() {
		// TODO Auto-generated method stub
		if(texture == null)
			texture = Art.title;
		texture.bind();
		
		float alpha = 0;
		if(counter < wait)
			return;
		else if(counter < in+wait) {
			alpha = (counter-wait) / (float)in;
		}
		else if(counter >= in+wait && counter < in+show+wait) {
			alpha = 1;
		}
		else if(counter >= in+show+wait && counter < in+show+out+wait) {
			alpha = (out-counter+in+show+wait)/(float)out;
		} else
			return;
		GL11.glPushMatrix();
		GL11.glColor4f(1, 1, 1, alpha);
		GL11.glTranslatef(world.player.pos.x, world.player.pos.y , 0);
		GL11.glRotatef(-90, 0, 0, 1);

		GL11.glScalef(512, 512, 0);

		GL11.glBegin(GL11.GL_QUADS);
		GL11.glTexCoord2f(0, 0);
		GL11.glVertex2f(-0.5f, -0.5f);
		GL11.glTexCoord2f(0, texture.getHeight());
		GL11.glVertex2f(0.5f, -0.5f);
		GL11.glTexCoord2f(texture.getWidth(), texture.getHeight());
		GL11.glVertex2f(0.5f, 0.5f);
		GL11.glTexCoord2f(texture.getWidth(), 0);
		GL11.glVertex2f(-0.5f, 0.5f);
		GL11.glEnd();

		GL11.glPopMatrix();
	}

	@Override
	public boolean isAlive() {
		// TODO Auto-generated method stub
		return true;
	}

}
